/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.ar;

import com.ibm.hsc.ccfw.pa.system.PICecFsp;
import com.ibm.hsc.ccfw.pa.system.PIFsp;
import com.ibm.hsc.client.PIHSCCECClient;
import com.ibm.hsc.client.PIHSCClientObjectFactory;
import com.ibm.hsc.client.PIHSCSysClient;
import com.ibm.hsc.common.exceptions.PIHscClientException;
import com.ibm.hwmca.base.pa.domain.ConsoleAnalysisDomain;
import com.ibm.hwmca.base.pa.problem.FailingSystemProblemFilter;
import com.ibm.hwmca.base.pa.problem.PendingDumpFilter;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.domain.DomainManager;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEvent;
import com.ibm.hwmca.fw.pa.event.ProblemAnalysisEventListener;
import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.pa.problem.ProblemFactory;
import com.ibm.hwmca.fw.pa.problem.ProblemFilter;
import com.ibm.hwmca.fw.pa.problem.ProblemManager;
import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEvent;
import com.ibm.hwmca.fw.service.serviceableevent.ServiceableEventFilter;
import com.ibm.hwmca.fw.service.system.util.ServiceInterfaces;
import com.ibm.hwmca.fw.util.ByteArray;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.event.PIDumpEvent;
import com.ibm.hwmca.p.pa.problem.PLIDMatchFilter;
import com.ibm.hwmca.xfw.pa.ar.CommonServiceAnalysisRoutine;
import com.ibm.hwmca.xfw.pa.problem.CommonProblem;
import com.ibm.hwmca.xfw.pa.util.DirectorySpy;
import com.ibm.hwmca.xfw.pa.util.FileGrowingException;
import com.ibm.hwmca.xfw.pa.util.ProblemDataDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PIDumpAnalysisRoutine
extends CommonServiceAnalysisRoutine
implements ProblemAnalysisEventListener {
    private static final String TRACE_MASKT = "PPADPART";
    private static final String TRACE_MASKF = "PPADPARF";
    private static final String TRACE_MASKD = "PPADPARD";
    protected boolean standalone = false;

    public PIDumpAnalysisRoutine() {
        Trace.trace((String)TRACE_MASKD, (Object)"<-> ctor");
    }

    public void analyze(ProblemAnalysisEvent problemAnalysisEvent) {
        Trace.trace((String)TRACE_MASKF, (Object)"--> analyze() V.1.04.5-4-4");
        DumpThread dumpThread = new DumpThread();
        dumpThread.ourEvent = (PIDumpEvent)problemAnalysisEvent;
        Thread thread = new Thread(dumpThread);
        thread.setDaemon(true);
        thread.setName("Dump Handler thread");
        Trace.trace((String)TRACE_MASKF, (Object)"Starting the dump handler thread");
        thread.start();
        Trace.trace((String)TRACE_MASKF, (Object)"<-- analyze()");
    }

    private void oldcode() {
    }

    private void intiateDumpRequest(PASystem pASystem) {
        try {
            String string = pASystem.getMOSystemName();
            Trace.trace((String)TRACE_MASKD, (Object)("get the dump for " + string));
            PIHSCSysClient pIHSCSysClient = this.createSysClient(string, pASystem);
            if (null != pIHSCSysClient) {
                String string2 = ((PIFsp)pASystem).getLocationCode();
                String[] stringArray = pIHSCSysClient.queryDump(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    Trace.trace((String)TRACE_MASKF, (Object)("dump [" + i + "] is [" + stringArray[i] + "]"));
                }
                if (stringArray.length > 0 && !stringArray[1].equals("0")) {
                    Trace.trace((String)TRACE_MASKF, (Object)"got to get a platform dump");
                    pIHSCSysClient.getDump("sys", string2);
                }
                if (stringArray.length > 1 && !stringArray[2].equals("0")) {
                    Trace.trace((String)TRACE_MASKF, (Object)"got to get an sp dump");
                    pIHSCSysClient.getDump("sp", string2);
                }
                Trace.trace((String)TRACE_MASKD, (Object)"-- getDump() completed successfully");
            }
        }
        catch (PIHscClientException pIHscClientException) {
            Trace.trace((String)TRACE_MASKF, (Object)"got a PIHscClientException");
            Trace.trace((String)TRACE_MASKF, (Object)pIHscClientException);
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)"got an UnknownHostException");
            Trace.trace((String)TRACE_MASKF, (Object)unknownHostException);
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)"got an Exception");
            Trace.trace((String)TRACE_MASKF, (Object)exception);
        }
    }

    private PIHSCCECClient createCECClient(String string) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ManageDumpsTasklet.createCECClient()");
        PIHSCCECClient pIHSCCECClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                String string3 = string;
                Trace.trace((String)TRACE_MASKD, (Object)("-- theSystem (selected system name) is: " + string3));
                pIHSCCECClient = pIHSCClientObjectFactory.createCECClient(string3, false);
                if (null == pIHSCCECClient) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- Cannot create PIHSCCECClient - client is null");
                    throw new HException("Couldn't find the CEC");
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5Client is: " + exception));
                throw new HException((Throwable)exception);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw new HException((Throwable)unknownHostException);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ManageDumpsTasklet.createCECClient()");
        return pIHSCCECClient;
    }

    private PIHSCSysClient createSysClient(String string, PASystem pASystem) throws Exception {
        Trace.trace((String)TRACE_MASKT, (Object)"-> ManageDumpsTasklet.createSysClient()");
        PIHSCSysClient pIHSCSysClient = null;
        String string2 = null;
        try {
            string2 = InetAddress.getLocalHost().getHostName();
            Trace.trace((String)TRACE_MASKF, (Object)("-- theHostName is: " + string2));
            try {
                PIHSCClientObjectFactory pIHSCClientObjectFactory = PIHSCClientObjectFactory.getInstance(string2, null);
                String string3 = string;
                Trace.trace((String)TRACE_MASKD, (Object)("-- theSystem (selected system name) is: " + string3));
                pIHSCSysClient = pASystem instanceof PICecFsp ? pIHSCClientObjectFactory.createSysClient(string, false, 0) : pIHSCClientObjectFactory.createSysClient(string, false, 1);
                if (null == pIHSCSysClient) {
                    Trace.trace((String)TRACE_MASKF, (Object)"-- Cannot create PIHSCSysClient - client is null");
                    throw new HException("Couldn't find the SYS");
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)("-- Exception building the r5Client is: " + exception));
                throw new HException((Throwable)exception);
            }
        }
        catch (UnknownHostException unknownHostException) {
            Trace.trace((String)TRACE_MASKF, (Object)("-- no HMC hostname, Exception is: " + unknownHostException));
            throw new HException((Throwable)unknownHostException);
        }
        Trace.trace((String)TRACE_MASKT, (Object)"<- ManageDumpsTasklet.createCECClient()");
        return pIHSCSysClient;
    }

    protected CommonProblem checkForPlidMatchProblem(File file, PASystem pASystem) {
        CommonProblem commonProblem = null;
        int n = this.getPLID(file);
        if (n != 0) {
            Trace.trace((String)TRACE_MASKD, (Object)("the plid to look for is " + n));
            FailingSystemProblemFilter failingSystemProblemFilter = new FailingSystemProblemFilter((Object)pASystem);
            PLIDMatchFilter pLIDMatchFilter = new PLIDMatchFilter(n);
            List list = this.getFilteredProblemList((ProblemFilter)failingSystemProblemFilter);
            if (!list.isEmpty()) {
                Trace.trace((String)TRACE_MASKF, (Object)("found " + list.size() + " problems for " + pASystem));
                ArrayList arrayList = new ArrayList();
                pLIDMatchFilter.filter(arrayList, list);
                if (!arrayList.isEmpty()) {
                    commonProblem = (CommonProblem)arrayList.get(0);
                    Trace.trace((String)TRACE_MASKF, (Object)("got a pending dump with problem " + commonProblem.getUniqueKey()));
                }
            } else {
                Trace.trace((String)TRACE_MASKD, (Object)("there are no matching plid problems " + pASystem));
            }
        } else {
            Trace.trace((String)TRACE_MASKD, (Object)"couldn't read the plid out of the dump file");
        }
        return commonProblem;
    }

    protected List getFilteredProblemList(ProblemFilter problemFilter) {
        List list = Collections.EMPTY_LIST;
        ProblemManager problemManager = null;
        try {
            problemManager = ProblemManager.getProblemManager();
            if (problemManager != null) {
                list = problemManager.filter((ServiceableEventFilter)problemFilter);
            } else {
                Trace.trace((String)TRACE_MASKD, (Object)"the pm was null");
            }
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)"got a exception getting the PM");
            Trace.trace((String)TRACE_MASKF, (Object)exception);
        }
        return list;
    }

    protected CommonProblem checkForPendingDumpProblem(File file, PASystem pASystem) {
        Trace.trace((String)TRACE_MASKF, (Object)("--> checkForPendingDumpProblem for (" + pASystem + ")"));
        CommonProblem commonProblem = null;
        FailingSystemProblemFilter failingSystemProblemFilter = new FailingSystemProblemFilter((Object)pASystem);
        PendingDumpFilter pendingDumpFilter = new PendingDumpFilter();
        List list = this.getFilteredProblemList((ProblemFilter)failingSystemProblemFilter);
        if (!list.isEmpty()) {
            ArrayList arrayList = new ArrayList();
            pendingDumpFilter.filter(arrayList, list);
            if (!arrayList.isEmpty()) {
                commonProblem = (CommonProblem)arrayList.get(0);
                Trace.trace((String)TRACE_MASKF, (Object)("got a pending dump with problem " + commonProblem.getUniqueKey()));
            } else {
                Trace.trace((String)TRACE_MASKD, (Object)("there are no pending dumps for " + pASystem));
            }
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"there were no open pending problems");
        }
        Trace.trace((String)TRACE_MASKF, (Object)"<-- checkForPendingDumpProblem()");
        return commonProblem;
    }

    public CommonProblem createNewDumpProblem(PASystem pASystem) {
        ProblemFactory problemFactory;
        CommonProblem commonProblem;
        block7: {
            Trace.trace((String)TRACE_MASKF, (Object)"--> createNewDumpProblem()");
            commonProblem = null;
            try {
                problemFactory = (ProblemFactory)ServiceInterfaces.getFactory((Object)pASystem, (String)"ProblemFactory");
                if (problemFactory != null) {
                    commonProblem = (CommonProblem)problemFactory.createProblem((Object)pASystem, "DumpProblem");
                    commonProblem.setFailingSystem(pASystem);
                    ProblemManager problemManager = ProblemManager.getProblemManager();
                    problemManager.add((ServiceableEvent)commonProblem);
                } else {
                    Trace.trace((String)TRACE_MASKF, (Object)"couldn't get the factory");
                    if (this.standalone) {
                        commonProblem = new CommonProblem();
                        commonProblem.setFailingSystem(pASystem);
                    }
                }
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)"got an exception");
                Trace.trace((String)TRACE_MASKF, (Object)exception);
                if (!this.standalone) break block7;
                commonProblem = new CommonProblem();
            }
        }
        if (commonProblem != null) {
            problemFactory = (ConsoleAnalysisDomain)DomainManager.getDomainManager().get(ConsoleAnalysisDomain.CAD_DOMAINID);
            commonProblem.setFailingSystem(pASystem);
            if (!this.standalone) {
                commonProblem.setPrimaryAnalyzingConsoleSystem((PASystem)problemFactory.getConsoleSystem());
            }
        }
        Trace.trace((String)TRACE_MASKF, (Object)"<-- createNewDumpProblem()");
        return commonProblem;
    }

    protected void associateProblem(CommonProblem commonProblem, File file, boolean bl) {
        Trace.trace((String)TRACE_MASKF, (Object)"--> associateProblem()");
        if (commonProblem != null && file != null) {
            Trace.trace((String)TRACE_MASKF, (Object)("Update problem " + commonProblem.getUniqueKey()));
            Trace.trace((String)TRACE_MASKF, (Object)("with " + file.getAbsolutePath()));
            ProblemDataDescriptor problemDataDescriptor = new ProblemDataDescriptor();
            problemDataDescriptor.setLocation(file.getAbsolutePath());
            problemDataDescriptor.setName(file.getName());
            problemDataDescriptor.setCallHomeCandidate(bl);
            commonProblem.addProblemDataSet(problemDataDescriptor);
            commonProblem.setDumpPending(false);
            try {
                ProblemManager problemManager = ProblemManager.getProblemManager();
                problemManager.changed((Problem)commonProblem);
            }
            catch (Exception exception) {
                Trace.trace((String)TRACE_MASKF, (Object)"got exception ");
                Trace.trace((String)TRACE_MASKF, (Object)exception);
            }
        } else {
            Trace.trace((String)TRACE_MASKF, (Object)"the problem or the file passed was null.");
        }
        Trace.trace((String)TRACE_MASKF, (Object)"<-- associateProblem()");
    }

    protected int getPLID(File file) {
        int n = 0;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            byte[] byArray = new byte[150];
            int n2 = fileInputStream.read(byArray, 0, 64);
            Trace.trace((String)TRACE_MASKD, (Object)"the data is:");
            Trace.trace((String)TRACE_MASKD, (Object)byArray);
            int n3 = ByteArray.extractU16((byte[])byArray, (int)8, (boolean)false);
            Trace.trace((String)TRACE_MASKD, (Object)("the end if the file directory is at " + n3));
            int n4 = n3;
            n2 = fileInputStream.read(byArray, 0, 32);
            Trace.trace((String)TRACE_MASKD, (Object)"read in the first section:");
            Trace.trace((String)TRACE_MASKD, (Object)"the data is:");
            Trace.trace((String)TRACE_MASKD, (Object)byArray);
            boolean bl = false;
            while (!bl) {
                int n5 = ByteArray.extractU16((byte[])byArray, (int)8, (boolean)false);
                Trace.trace((String)TRACE_MASKD, (Object)("the directory entry length is " + n5));
                long l = ByteArray.extractU32((byte[])byArray, (int)16, (boolean)false);
                Trace.trace((String)TRACE_MASKD, (Object)("last section data is " + l));
                if ((l & 1L) > 0L) {
                    bl = true;
                    Trace.trace((String)TRACE_MASKD, (Object)"last section is true");
                } else {
                    Trace.trace((String)TRACE_MASKD, (Object)"last section is false");
                }
                int n6 = n5 - 32;
                Trace.trace((String)TRACE_MASKD, (Object)("bytes to read are " + n6));
                int n7 = fileInputStream.read(byArray, 0, n6);
                Trace.trace((String)TRACE_MASKD, (Object)"the remainder data is:");
                Trace.trace((String)TRACE_MASKD, (Object)byArray);
                Trace.trace((String)TRACE_MASKD, (Object)"read the next header:");
                if (!bl) {
                    fileInputStream.read(byArray, 0, 32);
                    Trace.trace((String)TRACE_MASKD, (Object)"the next header:");
                    Trace.trace((String)TRACE_MASKD, (Object)byArray);
                    continue;
                }
                Trace.trace((String)TRACE_MASKD, (Object)"at the end don't read the next chunk");
            }
            Trace.trace((String)TRACE_MASKD, (Object)"we are at the end of the directory entires");
            Trace.trace((String)TRACE_MASKD, (Object)"read the plid in");
            fileInputStream.read(byArray, 0, 110);
            long l = ByteArray.extractU32((byte[])byArray, (int)104, (boolean)false);
            Trace.trace((String)TRACE_MASKD, (Object)("plid is " + Long.toString(l, 16)));
            n = (int)l;
        }
        catch (Exception exception) {
            Trace.trace((String)TRACE_MASKF, (Object)"got exeception read the file");
            Trace.trace((String)TRACE_MASKF, (Object)exception);
        }
        return n;
    }

    class DumpThread
    implements Runnable {
        protected CommonProblem theProblem;
        protected PIDumpEvent ourEvent;
        protected ProblemManager thePM;
        protected boolean threadError = false;
        protected boolean threadTimeOut = false;
        protected boolean callHomeCandidate = false;
        protected File[] threadFiles = null;

        DumpThread() {
        }

        public void run() {
            Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"--> DumpThread");
            File[] fileArray = new File("/dump").listFiles();
            Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"get the dump");
            PIDumpAnalysisRoutine.this.intiateDumpRequest(this.ourEvent.getSystem());
            PASystem pASystem = this.ourEvent.getSystem();
            Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKD, (Object)"done getting the dump");
            try {
                Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"wait for the dump to complete");
                File[] fileArray2 = DirectorySpy.waitOn((File)new File("/dump"), (File[])fileArray, (int)15, (int)12, (int)2);
                if (fileArray2 != null) {
                    Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"got a file to process");
                    this.threadFiles = fileArray2;
                } else {
                    Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"The dump file never got created");
                    this.threadTimeOut = true;
                }
            }
            catch (FileGrowingException fileGrowingException) {
                Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"the dump didn't complete in time");
                this.threadError = true;
            }
            if (!this.threadError || !this.threadTimeOut) {
                Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)("got " + this.threadFiles.length + " files to process"));
                for (int i = 0; i < this.threadFiles.length; ++i) {
                    if (!this.threadFiles[i].isFile()) continue;
                    Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"we are working with a file");
                    this.theProblem = PIDumpAnalysisRoutine.this.checkForPendingDumpProblem(this.threadFiles[i], pASystem);
                    this.callHomeCandidate = false;
                    if (this.theProblem == null) {
                        Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"the problem was null. check for plid match");
                        this.theProblem = PIDumpAnalysisRoutine.this.checkForPlidMatchProblem(this.threadFiles[i], pASystem);
                        this.callHomeCandidate = true;
                    }
                    if (this.theProblem == null) {
                        Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"need to create a problem");
                        this.theProblem = PIDumpAnalysisRoutine.this.createNewDumpProblem(pASystem);
                        this.callHomeCandidate = false;
                    }
                    Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"create the association");
                    PIDumpAnalysisRoutine.this.associateProblem(this.theProblem, this.threadFiles[i], this.callHomeCandidate);
                }
            } else {
                Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"got some kind of error");
            }
            Trace.trace((String)PIDumpAnalysisRoutine.TRACE_MASKF, (Object)"<-- DumpThread");
        }
    }
}

